#!/usr/bin/env python2.3
#
# An XMLRPC-over-Jabber client interface for Python.
# It's heavily borrowed from the excellent xmlrpclib.py
# and from Matthew Allum jrpc.py sample implementation.
#
#
# History: 
#          ver. 0.0.2 - 20041121  added Davin M.Potts patch to support
#                                 jabberpy v0.5.0 and client SSL connections
#          ver. 0.0.1 - 20031018  first public release.
#
#
# -----------------------
# Copyright 2003 by gian paolo ciceri <gp.ciceri@acm.org>
# under either GNU GPL/LGPL. All Rights Reserved.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of gian paolo ciceri
# not be used in advertising or publicity pertaining to distribution
# of the software without specific, written prior permission.
# GIAN PAOLO CICERI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# GIAN PAOLO CICERI BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
# IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#

"""

This class, using xmlrpclib, wraps an XML-RPC request
on an iq with the namespace 'jabber:iq:rpc' and sends
it to another jabber client, acting as a jrpc client.

For more info on this technique see http://www.pipetree.com/jabber/jrpc.html 

"""

__version__ = "0.0.2"

import sys, os

## Import jabber module
#from jabber 
import jabber

## Import xmlrpclib - included in python2.2 
import xmlrpclib

# to read config files
import xml.dom.minidom

class JabberXMLRPCClient:

   def __init__(self, con):
       self.con = con
    
   def buildPayload(self, method, params):
       #print xmlrpclib.dumps( params , methodname=method)
       return xmlrpclib.dumps( params , methodname=method)
   
   def buildRequest(self, iqTo, payload, iqID=0):
    
        ## Birth an iq object to send to self
        iq = jabber.Iq(to=iqTo, type="set")

        ## Set the i'qs query namespace
        iq.setQuery(jabber.NS_RPC)
        
        ## Set the ID
        iq.setID(iqID)


        ## Set the query payload - can be an XML document or
        ## a Node structure
        iq.setQueryPayload(payload)
        return iq

   def call(self, req_iq, timeout=5000):
        try:
            res = self.con.SendAndWaitForResponse(req_iq, timeout=timeout)
        except Except, e:
            print str(e)
        if res != None:
            params, method = xmlrpclib.loads("<?xml version='1.0'?>%s" % res)
            return params
        else:
            print "No answers returned from call"
            return None

whoIsOnline = {}

def presenceHandler_CB(self, pres_obj):
    who = str(pres_obj.getFrom())
    type = pres_obj.getType()
    print "presence: ", who
    if type == None:
       type = 'available'
    whoIsOnline[who] = type

def readConfigFile(configFile):  

    dom = xml.dom.minidom.parse(configFile)
       
    _server = dom.getElementsByTagName("server")[0]
    _username = dom.getElementsByTagName("username")[0]
    _password = dom.getElementsByTagName("password")[0]
    _resource = dom.getElementsByTagName("resource")[0]
    _rpcserverID = dom.getElementsByTagName("rpcserverID")[0]
    _timeout = dom.getElementsByTagName("timeout")[0]
    _port = dom.getElementsByTagName("port")[0]
    _connection = dom.getElementsByTagName("connection")[0]
    server   = str(_server.firstChild.nodeValue)
    username = str(_username.firstChild.nodeValue)
    password = str(_password.firstChild.nodeValue)
    resource = str(_resource.firstChild.nodeValue)
    rpcserverID = str(_rpcserverID.firstChild.nodeValue)
    timeout = int(_timeout.firstChild.nodeValue)
    port   = int(_port.firstChild.nodeValue)
    if str(_connection.firstChild.nodeValue) in ('TCP', 'TCP_SSL'):
        connection = eval('xmlstream.' + str(_connection.firstChild.nodeValue))
    else:
        connection = xmlstream.TCP

    return (server, username, password, resource, rpcserverID, timeout, port, connection)


def usage():
    print sys.argv[0], "usage: ", sys.argv[0], "configfile requestfile"
    sys.exit(-1)
    
    

if __name__ == '__main__':

    if (len(sys.argv) < 3):
       usage()


    ## Setup server and auth varibles
    server, username, password, resource, rpcserverID, timeout, port, connection = readConfigFile(sys.argv[1])

    # generate an unique resource ID   
    resource = resource + str(os.getpid())


    ## Get a jabber connection object, with logging to stderr
    con = jabber.Client(host=server, port=port, connection=connection, debug=0, log=0)
    con.setPresenceHandler(presenceHandler_CB)

    ## Try and connect
    try:
       con.connect()
    except Exception, e:
       print "Couldn't connect: %s" % str(e)
       sys.exit(0)
    else:
       print "Connected"

    ## Authenticate
    if con.auth(username, password, resource):
        print "Authenticated"
    else:
        print "Auth failed", con.lastErr, con.lastErrCode
        sys.exit(1)
          
    ## Get the roster and send presence. Maybe not needed but
    ## it's a good practise.    
    con.sendInitPresence()
    con.requestRoster()

    ## Initialize a RPC client
    jrpc = JabberXMLRPCClient(con)

    # set the RPC server    
    try:
        print "who is online:", whoIsOnline
        if (whoIsOnline[rpcserverID] == 'available'): 
            print "pid", os.getpid(), "server", rpcserverID, "available"
    except Exception, e:
        print "pid", os.getpid(), "server", rpcserverID, "unavailable: reason", str(e)        
        sys.exit(-1)
    
    ## answer queries
    dom = xml.dom.minidom.parse(sys.argv[2])
    
    calls = dom.getElementsByTagName("methodCall")
    for callNode in calls:
        params, method = xmlrpclib.loads("<?xml version='1.0'?>%s" % callNode.toxml())
        print "pid", os.getpid(), "calling:", method, "with parameters:", params

        # build iq message payload
        payload = jrpc.buildPayload(method, params)
        # build the request
        req_iq = jrpc.buildRequest(rpcserverID, payload, os.getpid())
    
        # call the remote method, and get the answer 
        answer = jrpc.call(req_iq, timeout)    
        print "pid", os.getpid(), "answer:", answer
 
    



