#!/usr/bin/python
# -*- coding: iso8859_2 -*-
#-----------------------------------------------------------------------------
# Name:        EasyJabberXMLRPCClient.py
# Author:      GDR!
# Created:     2006/03/19
# RCS-ID:      $Id: EasyJabberXMLRPCClient.py $
# Copyright:   (c)Cybertronika 2006
# Licence:     GPL+LGPL
#-----------------------------------------------------------------------------

import os
import jabber
import xmlstream
import JabberXMLRPCClient

class XMLRPCFunction:
    "Private class, represents an XMLRPC method"
    def __init__(self, client, name):
        self.Client = client
        self.Name = name
        
    def __call__(self, *args):
        return self.Client.Call(self.Name, args)

class EasyJabberXMLRPCClient:
    "Wrapper class for JabberXMLRPCClient. XMLRPC methods are called like this classes own"
    def __init__(self, JabberServer, JabberUsername, JabberPassword, RpcServerJid, JabberResource="rpcClient", JabberPort = 5223, JabberConnection = "SSL", ConnectionTimeout=20):
        self.JabberServer = JabberServer
        self.JabberUsername = JabberUsername
        self.JabberPassword = JabberPassword
        self.JabberResource = JabberResource
        self.RpcServerJid = RpcServerJid
        self.ConnectionTimeout = ConnectionTimeout
        self.JabberPort = 5223
        self.JabberRoster = {}
        self.jrpc = None
        
        if(JabberConnection == "SSL"):
            self.JabberConnection = xmlstream.TCP_SSL
        else:
            self.JabberConnection = xmlstream.TCP
        
        # generate an unique resource ID   
        self.JabberResource = self.JabberResource + str(os.getpid())
        
        ## Get a jabber connection object, with logging to stderr
#        self.JabberConn = jabber.Client(host=self.JabberServer, port=self.JabberPort, connection=self.JabberConnection, debug=[], log=0)
        self.JabberConn = jabber.Client(host=self.JabberServer, port=self.JabberPort, connection=self.JabberConnection, debug=[], log=0)
        self.JabberConn.registerHandler('presence', self._PresenceHandler)
        
        ## Try and connect
        try:
           self.JabberConn.connect()
        except Exception, e:
           raise "ConnectionError", "Couldn't connect: %s" % str(e)
        else:
           print "Connected"
    
        ## Authenticate
        if self.JabberConn.auth(self.JabberUsername, self.JabberPassword, self.JabberResource):
            print "Authenticated"
        else:
            raise "Auth failed", (self.JabberConn.lastErr, self.JabberConn.lastErrCode)
              
        ## Get the roster and send presence. Maybe not needed but
        ## it's a good practise.
        self.JabberConn.sendInitPresence()
        self.JabberConn.requestRoster()
    
        ## Initialize a RPC client
        self.jrpc = JabberXMLRPCClient.JabberXMLRPCClient(self.JabberConn)
        
        # set the RPC server    
        try:
            if (self.JabberRoster[self.RpcServerJid] == 'available'): 
                print "pid", os.getpid(), "server", self.RpcServerJid, "available"
        except Exception, e:
            raise "XMLRPCServerNotAvailable", ("pid", os.getpid(), "server", self.RpcServerJid, "unavailable: reason", str(e))

    def _PresenceHandler(self, w00t, pres_obj):
        "Wewnetrzny handler listy kontaktow"
        who = str(pres_obj.getFrom())
        type = pres_obj.getType()
        if type == None:
           type = 'available'
        self.JabberRoster[who] = type

    def Call(self, Method, Params):
        "Method: string, nazwa metody. Params: krotka, parametry metody. Zwraca: krotke z wartosciami zwroconymi przez funkcje"
        # build iq message payload
        payload = self.jrpc.buildPayload(Method, Params)
        # build the request
        req_iq = self.jrpc.buildRequest(self.RpcServerJid, payload, os.getpid())
    
        # call the remote method, and get the answer 
        answer = self.jrpc.call(req_iq, self.ConnectionTimeout)
        print "Call(", Method, ") = ", answer
        return answer[0]

    def __getattr__(self, attrname):
         return XMLRPCFunction(self, attrname)

        
if __name__ == '__main__':
    cli = EasyJabberXMLRPCClient(JabberServer="chrome.pl", JabberUsername = "_client", JabberPassword = "test", RpcServerJid = "_serv@chrome.pl/rpcServer")
#    cli = EasyJabberXMLRPCClient()
    print
    print "--Calls--"
    print "By pseudo-methods:"
    print cli.test(0x29a)
    print 
    print "By Call function:"
    print cli.Call("test", (0x29a,))

#    print cli.test("parm1", "parm2", ["parm3.1", {"parm 3.2.1": 3.21, "parm 3.2.2": 3.22}])
