#!/usr/bin/python
# -*- coding: iso8859_2 -*-
#-----------------------------------------------------------------------------
# Name:        EasyJabberXMLRPCServer.py
# Author:      GDR!
# Created:     2006/03/19
# RCS-ID:      $Id: SPSender.py $
# Copyright:   (c)Cybertronika 2005
# Licence:     GPL+LGPL
#-----------------------------------------------------------------------------

import JabberXMLRPCServer 
import xmlstream
import jabber

# Hardkorowy trick zeby do funkcji po stronie serwera nie byla przekazywana krotka, tylko lista parametrow
class XMLRPCServerFunction:
    "Private class, represents an XMLRPC method"
    def __init__(self, function, name = None):
        self.function = function
        if name:
            self.name = name
        else:
            self.name = function.__name__
        self.__name__ = self.name
        
    def __call__(self, *args):
#        print "!!!Calling:", self.name, args[0]
        result = self.function(*args[0])
#        print "RESULT:", result
        return (result,)
        
    def __repr__(self):
        if self.name:
            return "XMLRPCServerFunction object for function " + self.name

class EasyJabberXMLRPCServer:
    "Tries to reproduce SimpleXMLRPCServer as much as possible"
    def __init__(self, JabberServer = "chrome.pl", JabberUsername = "_serv", JabberPassword = "test", JabberResource="rpcServer", JabberPort = 5223, JabberConnection = "SSL", ConnectionTimeout = 5):
    
        if JabberConnection == "SSL":
            connection = xmlstream.TCP_SSL
        else:
            connection = xmlstream.TCP
            
        self.JabberServer = JabberServer
        self.JabberUsername = JabberUsername
        self.JabberPassword = JabberPassword
        self.JabberResource = JabberResource
        self.JabberPort = JabberPort
        self.JabberConnection = JabberConnection
        
        maxjobs = 20
    
        ## Get a jabber connection object, with logging to stderr
#        self.con = jabber.Client(host = JabberServer, port = JabberPort, connection = connection, debug=[], log = 0)
        self.con = jabber.Client(host = JabberServer, port = JabberPort, connection = connection, debug=[], log = 0)
    
    
        ## Try and connect
        try:
           self.con.connect()
        except Exception, e:
           raise "Couldn't connect to Jabber server", str(e)
#        else:
#           print "Connected"
    
        ## Authenticate
        if self.con.auth(JabberUsername, JabberPassword, JabberResource):
            #print "Authenticated"
            pass
        else:
            raise "Authentication failed", str((self.con.lastErr, self.con.lastErrCode))
              
        ## Get the roster and send presence. Maybe not needed but
        ## it's a good practise.
        self.con.requestRoster()
        self.con.sendInitPresence()
    
        ## Initialize a RPC server, with 5 max concurrent remote methods
        self.jrpcServer = JabberXMLRPCServer.JabberXMLRPCServer(self.con, maxjobs)
    
    def register_function(self, function, name = None):
        self.jrpcServer.registerMethod(XMLRPCServerFunction(function), name)
        
    def serve_forever(self):
        while 1:
            self.con.process(1)
    
    # nie wiem po co to, ale uznalem ze tak bedzie zabawniej :P
    def __repr__(self):
        return "Jabber XMLRPC server listening at %s@%s:%d/%s (Connection: %s)" % (self.JabberUsername, self.JabberServer, self.JabberPort, self.JabberResource, self.JabberConnection)

#Testujemy :]            
if __name__ == '__main__':
    def test(number):
        return "dupa" + str(number)

    serv = EasyJabberXMLRPCServer()
    serv.register_function(test)
    print serv
    serv.serve_forever()
    
    
